/*
 * Decompiled with CFR 0.152.
 */
package gar2rnx;

import gar2rnx.GpsSerial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class GpsCommSerial
extends GpsSerial {
    private SerialPort io = null;
    private InputStream in;
    private OutputStream out;

    public GpsCommSerial(String port, PrintStream traceStream) throws IOException {
        super(port, traceStream, true);
        this.GPS_Serial_Open(port);
        this.port = port;
    }

    protected void GPS_Serial_Open(String port) throws IOException {
        try {
            if (this.TRACE_IO) {
                this.TRACE.print("Available ports: ");
                Enumeration p = CommPortIdentifier.getPortIdentifiers();
                while (p.hasMoreElements()) {
                    this.TRACE.print(((CommPortIdentifier)p.nextElement()).getName() + " ");
                }
                this.TRACE.println();
            }
            CommPortIdentifier commPort = CommPortIdentifier.getPortIdentifier((String)port);
            this.io = (SerialPort)commPort.open("gar2rnx", 500);
            this.io.setSerialPortParams(9600, 8, 1, 0);
            this.io.enableReceiveTimeout(100);
            this.in = this.io.getInputStream();
            this.out = this.io.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    void GPS_Serial_Close() throws IOException {
        this.in.close();
        this.out.close();
        this.io.close();
    }

    boolean GPS_Serial_Chars_Ready() {
        try {
            return this.in.available() > 0;
        }
        catch (IOException e) {
            if (this.TRACE_IO) {
                e.printStackTrace(this.TRACE);
            }
            return false;
        }
    }

    void setTimeout(int millis) {
        try {
            this.io.enableReceiveTimeout(millis);
        }
        catch (UnsupportedCommOperationException ue) {}
    }
}

