/*
 * Decompiled with CFR 0.152.
 */
package gar2rnx;

import gar2rnx.GpsCommSerial;
import gar2rnx.GpsSerial;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Async {
    static final String VERSION = "1.20";
    static final String JVERSION = "0.4";
    private static final boolean TRACE_IO = false;
    private static final String TRACE_FILE = "trace.txt";
    private static final int screenWidth = 31;
    private static final int CHECK = 1;
    private static final int IDENT = 2;
    private static final int ASYNC = 3;
    private static final int REQST = 4;
    private static final int RINEX = 5;
    private static final int DOPPLER = 6;
    private static final int DEF_COMMAND = 2;
    private static final int DEF_FLAG = 65535;
    private static final int DEF_FLAG_REQUEST = 1;
    private static final int DEF_LOG_TIME = 30;
    private static final int DEF_VERBOSE_LEVEL = 1;
    private static final String DEF_PORT = "COM1";
    private static final double M_PI = Math.PI;
    private static final int MAXBUF = 512;
    private static final byte EOD = 12;
    private static final byte DLE = 16;
    private static final byte ETX = 3;
    private static final byte ACK = 6;
    private static final byte NAK = 21;
    private static final int DAT_ST = 0;
    private static final int DLE_ST = 1;
    private static final int ETX_ST = 2;
    private static final int MAX_FAILED = 50;
    private static final int E_ABRIR = 0;
    private static final int E_SETUP = 1;
    private static final int E_GETCOMM = 2;
    private static final int E_SETCOMM = 3;
    private static final int E_GETTIME = 4;
    private static final int E_SETTIME = 5;
    private static final int E_PURGE = 6;
    private static final int E_CERRAR = 7;
    private static final int E_READ = 8;
    private static final int E_TIMEOUT = 9;
    private static final int E_EXPECTED_ACK = 10;
    private static final int E_EXPECTED_PACKET = 11;
    private static final int E_WRITE = 16;
    private static final int E_WRITE_SHORT = 17;
    private static final int E_CREATE_FILE = 20;
    private static final int E_CLOSE_FILE = 21;
    private static final int E_ORDEN = 31;
    PrintStream TRACE;
    long CHARS_READ;
    boolean CHKSUM = false;
    boolean ACK_PACKETS = true;
    int rx_state = 0;
    byte[] buffer = new byte[512];
    byte[] inbuffer = new byte[512];
    String PORT;
    longPtr p_error_code;
    int verbose;
    GpsSerial pcom;

    static String hex(byte b) {
        short unsignedByte = Async.unsignedByte(b);
        if (unsignedByte >= 16) {
            return Integer.toHexString(unsignedByte);
        }
        return "0" + Integer.toHexString(unsignedByte);
    }

    static short unsignedByte(byte b) {
        return b >= 0 ? (short)b : (short)(256 + b);
    }

    static double toDouble(byte[] in, int offset) {
        long lBuf = (long)Async.unsignedByte(in[offset]) | (long)Async.unsignedByte(in[1 + offset]) << 8 | (long)Async.unsignedByte(in[2 + offset]) << 16 | (long)Async.unsignedByte(in[3 + offset]) << 24 | (long)Async.unsignedByte(in[4 + offset]) << 32 | (long)Async.unsignedByte(in[5 + offset]) << 40 | (long)Async.unsignedByte(in[6 + offset]) << 48 | (long)Async.unsignedByte(in[7 + offset]) << 56;
        return Double.longBitsToDouble(lBuf);
    }

    boolean open_port(String ComPort) {
        try {
            try {
                this.pcom = new GpsCommSerial(ComPort, this.TRACE);
            }
            catch (NoClassDefFoundError e) {
                System.out.println("No javax.comm package - switching to file-based serial access. You should set serial port parameters to 9600,n,8,1 manually.");
                this.pcom = new GpsSerial(ComPort, this.TRACE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.set_error(0);
            return false;
        }
        return true;
    }

    boolean close_port() {
        try {
            this.pcom.GPS_Serial_Close();
        }
        catch (IOException e) {
            this.set_error(7);
            return false;
        }
        return true;
    }

    int purge_comm(GpsSerial fd) {
        int i = 0;
        try {
            while (((GpsCommSerial)fd).GPS_Serial_Chars_Ready()) {
                int res = fd.read();
                if (res != -1) {
                    byte x = (byte)res;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (ClassCastException e) {}
        return i;
    }

    final void show_in(int n) {
    }

    final void show_out(int n) {
    }

    final void pausa(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {}
    }

    final int read_char(bytePtr x) {
        try {
            int intX = this.pcom.read();
            if (intX == -1) {
                this.set_error(9);
                return 0;
            }
            x.value = (byte)intX;
            ++this.CHARS_READ;
            return 1;
        }
        catch (IOException e) {
            this.set_error(8);
            this.close_port();
            return 0;
        }
    }

    final int read_packet() {
        bytePtr c = new bytePtr();
        int buf_ptr = 0;
        block5: while (true) {
            if (this.read_char(c) == 0) {
                return 0;
            }
            switch (this.rx_state) {
                case 0: {
                    if (c.value == 16) {
                        this.rx_state = 1;
                        continue block5;
                    }
                    this.inbuffer[buf_ptr++] = c.value;
                    continue block5;
                }
                case 1: {
                    if (c.value == 3) {
                        this.rx_state = 2;
                        return buf_ptr;
                    }
                    this.inbuffer[buf_ptr++] = c.value;
                    this.rx_state = 0;
                    continue block5;
                }
                case 2: {
                    if (c.value != 16) continue block5;
                    this.rx_state = 1;
                    continue block5;
                }
            }
            if (buf_ptr == 512) break;
        }
        return 0;
    }

    final void check_packet(int n) {
        byte chksum = 0;
        int k = 0;
        while (k < n) {
            chksum = (byte)(chksum + this.inbuffer[k]);
            ++k;
        }
        this.CHKSUM = chksum == 0;
    }

    final int read_data(boolean answer) {
        int nb = this.read_packet();
        if (nb == 0) {
            this.set_error(11);
            return 0;
        }
        this.show_in(nb);
        this.check_packet(nb);
        if (answer) {
            byte id = this.inbuffer[0];
            this.send_ack(id, this.CHKSUM);
            if (!this.CHKSUM) {
                nb = this.read_data(true);
            }
        }
        return nb;
    }

    final int build_packet(byte[] data) {
        byte L = data[1];
        int chk = 0;
        int cont = 0;
        this.buffer[cont++] = 16;
        int k = 0;
        while (k < L + 2) {
            chk = (short)(chk + data[k]);
            this.buffer[cont++] = data[k];
            if (data[k] == 16) {
                this.buffer[cont++] = 16;
            }
            ++k;
        }
        chk = (short)(-chk);
        this.buffer[cont++] = (byte)chk;
        if (chk == 16) {
            this.buffer[cont++] = 16;
        }
        this.buffer[cont++] = 16;
        this.buffer[cont++] = 3;
        return cont;
    }

    final int send_ack(byte id, boolean ok) {
        byte[] data = new byte[]{ok ? (byte)6 : 21, 2, id, 0};
        int nbytes = this.build_packet(data);
        int n = -1;
        try {
            this.pcom.write(this.buffer, 0, nbytes);
            n = nbytes;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (n == -1) {
            this.set_error(16);
            this.close_port();
            return 0;
        }
        this.show_out(n);
        return n;
    }

    final int read_ack(byte id) {
        long WAIT_FOR_ACK = 50L;
        this.pausa(WAIT_FOR_ACK);
        int bytesRead = this.read_packet();
        if (bytesRead == 0) {
            this.set_error(10);
            return 0;
        }
        this.check_packet(bytesRead);
        this.show_in(bytesRead);
        byte ack = this.inbuffer[0];
        return ack;
    }

    final int send_packet(byte[] data) {
        byte id = data[0];
        int nbytes = this.build_packet(data);
        try {
            this.pcom.write(this.buffer, 0, nbytes);
        }
        catch (IOException e) {
            this.set_error(16);
            this.close_port();
            return 0;
        }
        this.show_out(nbytes);
        if (!this.ACK_PACKETS) {
            this.ACK_PACKETS = true;
            return nbytes;
        }
        int r = this.read_ack(id);
        if (r == 0) {
            return 0;
        }
        if (r == 21) {
            try {
                r = -1;
                this.pcom.write(this.buffer, 0, nbytes);
                r = nbytes;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (r == -1) {
                this.set_error(16);
                this.close_port();
                return 0;
            }
            this.show_out(r);
        }
        return r;
    }

    void set_error(int n) {
        this.p_error_code.value |= 1L << n;
    }

    final short get_int(byte[] ptr, int off) {
        short x = Async.unsignedByte(ptr[off]);
        x = (short)(x + 256 * Async.unsignedByte(ptr[off + 1]));
        return x;
    }

    final int get_long(byte[] ptr, int off) {
        int x = Async.unsignedByte(ptr[off]);
        x += 256 * Async.unsignedByte(ptr[off + 1]);
        x += 65536 * Async.unsignedByte(ptr[off + 2]);
        return x += 0x1000000 * Async.unsignedByte(ptr[off + 3]);
    }

    void check_port() {
        if (this.open_port(this.PORT)) {
            System.out.println("Opening port " + this.PORT);
            if (this.close_port()) {
                System.out.println("Closing port " + this.PORT);
            }
        }
    }

    void ident() {
        int bptr = 2;
        byte[] PROD_ID = new byte[]{-2, 0};
        if (!this.open_port(this.PORT)) {
            return;
        }
        if (this.send_packet(PROD_ID) == 0) {
            this.close_port();
            return;
        }
        int buflen = this.read_data(true);
        if (buflen == 0) {
            this.close_port();
            return;
        }
        if (!this.close_port()) {
            return;
        }
        short prod = this.get_int(this.inbuffer, bptr);
        short ver = this.get_int(this.inbuffer, bptr += 2);
        System.out.println("Product ID: " + prod + " (\"" + new String(this.inbuffer, bptr += 2, buflen - bptr - 2) + "\"). Firmware " + (double)ver / 100.0);
    }

    boolean get_pos(boolean p) {
        byte[] SEND_POS = new byte[]{10, 2, 2, 0};
        if (!this.open_port(this.PORT)) {
            return false;
        }
        if (this.send_packet(SEND_POS) == 0) {
            this.close_port();
            return false;
        }
        if (this.read_data(true) == 0) {
            this.close_port();
            return false;
        }
        if (p && this.verbose >= 1) {
            double lat = Async.toDouble(this.inbuffer, 2);
            double lon = Async.toDouble(this.inbuffer, 10);
            System.out.println("Position  : Lat " + (lat *= 57.29577951308232) + "  long " + (lon *= 57.29577951308232));
        }
        this.close_port();
        return true;
    }

    final double julday(int year, int month, int day, int hour, int min, double sec) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        double jd = Math.floor(365.25 * (double)year) + Math.floor(30.6001 * (double)(month + 1)) + (double)day + ((double)hour + ((double)min + sec / 60.0) / 60.0) / 24.0 + 1720981.5;
        return jd;
    }

    final double gps_time(double julday, intPtr week) {
        double days_gps = julday - 2444244.5;
        int wn = (int)Math.floor(days_gps / 7.0);
        double tow = (days_gps - (double)(wn * 7)) * 86400.0;
        if ((tow += 13.0) >= 604800.0) {
            tow -= 604800.0;
            ++wn;
        }
        week.value = wn;
        return tow;
    }

    final boolean get_date(boolean p) {
        UTC utc = new UTC();
        byte[] SEND_TIME = new byte[]{10, 2, 5, 0};
        intPtr week = new intPtr();
        if (!this.open_port(this.PORT)) {
            return false;
        }
        if (this.send_packet(SEND_TIME) == 0) {
            this.close_port();
            return false;
        }
        if (this.read_data(true) == 0) {
            this.close_port();
            return false;
        }
        if (p && this.verbose > 0) {
            utc.month = this.inbuffer[2];
            utc.day = this.inbuffer[3];
            utc.year = this.get_int(this.inbuffer, 4);
            utc.hour = this.get_int(this.inbuffer, 6);
            utc.min = this.inbuffer[8];
            utc.sec = this.inbuffer[9];
            double jd = this.julday(utc.year, utc.month, utc.day, utc.hour, utc.min, utc.sec);
            double tow = this.gps_time(jd, week);
            System.out.print("Civil Date: ");
            System.out.print(utc.day + "/" + utc.month + "/" + utc.year + " ");
            System.out.println(utc.hour + ":" + utc.min + ":" + utc.sec);
            System.out.print("GPS Time  : ");
            System.out.println("GPS Week " + week.value + " ToW " + (int)Math.rint(tow) + " sec. Garmin Weekdays " + (week.value - 521) * 7);
        }
        this.close_port();
        return true;
    }

    boolean async(int flag_async) {
        byte[] orden = new byte[]{28, 2, 0, 0};
        orden[2] = (byte)(flag_async % 256);
        orden[3] = (byte)(flag_async / 256);
        if (flag_async != 0) {
            if (!this.open_port(this.PORT)) {
                return false;
            }
            if (this.send_packet(orden) == 0) {
                this.close_port();
                return false;
            }
            if (this.read_data(false) == 0) {
                this.close_port();
                return false;
            }
            if (this.read_data(false) == 0) {
                this.close_port();
                return false;
            }
        } else {
            this.ACK_PACKETS = false;
            if (this.send_packet(orden) == 0) {
                this.close_port();
                return false;
            }
            this.pausa(600L);
            this.purge_comm(this.pcom);
            if (!this.close_port()) {
                return false;
            }
        }
        return true;
    }

    boolean clear_line() {
        byte[] disable = new byte[]{28, 2, 0, 0};
        if (!this.open_port(this.PORT)) {
            return false;
        }
        this.ACK_PACKETS = false;
        if (this.send_packet(disable) == 0) {
            this.close_port();
            return false;
        }
        this.pausa(600L);
        this.purge_comm(this.pcom);
        return this.close_port();
    }

    final void write_packet(FileOutputStream dest) {
        try {
            dest.write(this.inbuffer, 0, this.inbuffer[1] + 2);
            dest.flush();
        }
        catch (IOException e) {}
    }

    final void log_packets_0x33(FileOutputStream f_bin) {
        double dt;
        long ok = 0L;
        long rec = 0L;
        double MAX_WAIT = 10.0;
        if (this.verbose != 0) {
            System.out.print("-----------------------------------------------------------------\n");
            System.out.print("Waiting for a 3D fix  (" + MAX_WAIT + " secs at most)\n");
        }
        double start = new Date().getTime() / 1000L;
        if (!this.async(65535)) {
            return;
        }
        this.pcom.setTimeout(5000);
        do {
            int n = this.read_data(false);
            dt = (double)(new Date().getTime() / 1000L) - start;
            if (n == 0 || !this.CHKSUM || this.inbuffer[0] != 51) continue;
            ++rec;
            short fix = this.get_int(this.inbuffer, 18);
            if (fix >= 3) {
                this.write_packet(f_bin);
                ++ok;
            }
            if (this.verbose == 0) continue;
            System.out.print(dt + " s: " + rec + " rcvd, " + ok + " 3D\r");
        } while (dt < MAX_WAIT && ok < 5L);
        this.pcom.setTimeout(100);
        this.async(0);
        if (this.verbose != 0) {
            System.out.print("                                                             \r");
            System.out.print(dt + " secs: " + rec + " packets with 0x33 ID received. " + ok + " with a 3D fix\n");
        }
        if (dt >= MAX_WAIT) {
            System.out.print("-----------------------------------------------------------------\n");
            System.out.print(MAX_WAIT + " seconds waiting for 0x33 records with a 3D fix\n");
            System.out.print("Does your GPS screen show a 3D fix?\n");
            System.out.print("You probably won't get a proper RINEX file under these circustances\n");
            System.out.print("Lets give it a try, just in case your GPS doesn't sent out 0x33 records\n");
        }
    }

    final void log_packets_async(int flag, double T_LOG, FileOutputStream f_bin) {
        double dt;
        long cont = 0L;
        int failed = 0;
        if (this.verbose != 0) {
            System.out.print("-----------------------------------------------------------------\n");
        }
        double start = new Date().getTime() / 1000L;
        if (!this.async(flag)) {
            return;
        }
        this.CHARS_READ = 0L;
        this.pcom.setTimeout(1000);
        do {
            int n = this.read_data(false);
            dt = (double)(new Date().getTime() / 1000L) - start;
            if (n == 0) {
                ++failed;
            } else {
                this.p_error_code.value = 0L;
                if (this.CHKSUM) {
                    this.write_packet(f_bin);
                    ++cont;
                }
            }
            if (this.verbose == 0) continue;
            System.out.print(T_LOG - dt + " s: " + cont + "+ " + failed + "-. 0x" + Async.hex(this.inbuffer[0]) + " \r");
        } while (dt < T_LOG && failed < 50);
        this.pcom.setTimeout(100);
        if (this.verbose != 0) {
            System.out.print("                                                                           \r");
            System.out.print("Comm Stats: Chars " + this.CHARS_READ + " (" + (double)this.CHARS_READ * 8.0 / (1024.0 * dt) + " Kbit/s): " + cont + " OK records. " + failed + " failed reads\n");
            if (failed >= 50) {
                System.out.print("Too many failed packets. Clossing connection now\n");
            }
        }
        if (this.p_error_code.value == 2560L) {
            this.close_port();
            this.clear_line();
        } else {
            this.async(0);
        }
        if (this.verbose != 0) {
            System.out.print("-----------------------------------------------------------------\n");
        }
    }

    final long log_packets_request(int flag_request, FileOutputStream dest) {
        byte[] orden = new byte[]{10, 2, 7, 0};
        orden[2] = (byte)(flag_request % 256);
        orden[3] = (byte)(flag_request / 256);
        if (!this.open_port(this.PORT)) {
            return 0L;
        }
        if (this.send_packet(orden) == 0) {
            this.close_port();
            return 0L;
        }
        if (this.read_data(true) == 0) {
            this.close_port();
            return 0L;
        }
        if (this.verbose != 0) {
            System.out.print("-----------------------------------------------------------------\n");
        }
        this.write_packet(dest);
        if (this.inbuffer[0] != 27) {
            this.close_port();
            if (this.verbose != 0) {
                System.out.print("One record received\n");
                System.out.print("-----------------------------------------------------------------\n");
            }
            return 1L;
        }
        long nrecords = this.get_int(this.inbuffer, 2);
        this.pausa(80L);
        long k = 0L;
        do {
            this.pausa(20L);
            if (this.read_data(true) == 0) {
                this.close_port();
                return 0L;
            }
            if (this.verbose != 0) {
                System.out.print("Records   : " + nrecords + " expected. " + k + " rcvd  \r");
            }
            this.write_packet(dest);
            ++k;
        } while (this.inbuffer[0] != 12);
        --k;
        if (this.verbose != 0) {
            System.out.print("Records   : " + nrecords + " expected. " + k + " actually received\n");
            System.out.print("-----------------------------------------------------------------\n");
        }
        this.close_port();
        return k;
    }

    final boolean check_bit(long x, int pos) {
        long mask = 1 << pos;
        return (x & mask) != 0L;
    }

    void show_err_msg(long n) {
        if (n == 0L) {
            if (this.verbose == 2) {
                System.out.print("No comm errors during process\n");
            }
            return;
        }
        System.out.print("Serial Comm Error " + n + " -> 0x" + Long.toHexString(n) + ": ");
        if (this.check_bit(n, 0)) {
            System.out.print("Can't open serial port\nPossibly being used by another aplication\n");
        }
        if (this.check_bit(n, 1)) {
            System.out.print("Error in SETUP COMM port\n");
        }
        if (this.check_bit(n, 2)) {
            System.out.print("Error in  GetComm\n");
        }
        if (this.check_bit(n, 3)) {
            System.out.print("Error in  SetComm\n");
        }
        if (this.check_bit(n, 4)) {
            System.out.print("Error in  GetTimeOuts\n");
        }
        if (this.check_bit(n, 5)) {
            System.out.print("Error in  SetTimeOuts\n");
        }
        if (this.check_bit(n, 6)) {
            System.out.print("Error purging COM port\n");
        }
        if (this.check_bit(n, 7)) {
            System.out.print("Error closing COM port: maybe it is already closed\n");
        }
        if (this.check_bit(n, 8)) {
            System.out.print("Hardware Error reading COMM port\n");
        }
        if (this.check_bit(n, 9) && this.check_bit(n, 10)) {
            System.out.print("TIMEOUT waiting for ACK\n");
            System.out.print("GPS doesn't answer in " + this.PORT + ": Is it on and in GRMN/GRMN mode?\n");
        }
        if (this.check_bit(n, 9) && this.check_bit(n, 11)) {
            System.out.print("TIMEOUT waiting for a PACKET\n");
            System.out.print("GPS doesn't answer in " + this.PORT + ": Is it on and in GRMN/GRMN mode?\n");
        }
        if (this.check_bit(n, 16)) {
            System.out.print("Hardware Error when sending data to COM port\n");
        }
        if (this.check_bit(n, 17)) {
            System.out.print("Short Write in COM port\n");
        }
        if (this.check_bit(n, 20)) {
            System.out.print("Cannot create output file\n");
        }
        if (this.check_bit(n, 21)) {
            System.out.print("Cannot close output file\n");
        }
        if (this.check_bit(n, 31)) {
            System.out.print("Command not recognized; You should not be seeing this\n");
        }
    }

    void print_help() {
        StringBuffer help = new StringBuffer(2048);
        help.append("  -----------------------------------------------------------------\n");
        help.append("  * Async Software to log raw GPS data from some Garmin handhelds *\n");
        help.append("  * Version ").append(VERSION).append("    Copyright 2000,2001   Antonio Tabernero Galan *\n");
        help.append("  * Java port ver. ").append(JVERSION).append("    (c) 2002,2004  MichalHobot@netscape.net *\n");
        help.append("  -----------------------------------------------------------------\n");
        help.append("  Usage:\n");
        help.append("    async or async -h: shows this help\n");
        help.append("    async command [options]\n\n");
        help.append("------------------- ASYNC COMMANDS ------------------------------\n\n");
        help.append("    async -c : only checks port availability\n");
        help.append("    async -i : only tries to get the GPS ID (default)\n");
        help.append("    async -a 0xnnnn : Enable async events with hex mask nnnn\n");
        help.append("    async -r 0xnnnn : Sends request type nnnn.\n");
        help.append("    async -rinex : by enabling only those records relevant to the\n");
        help.append("                   generation of a RINEX file you avoid missing\n");
        help.append("                   observations (that can happen when there are too\n");
        help.append("                   many async events coming). Use this option when you\n");
        help.append("                   plan to generate a RINEX file from the collected data\n");
        help.append("    async +doppler: if you're using the latest version (1.2 or newer) of\n");
        help.append("                    async you can get Doppler shift data in addition to\n");
        help.append("                    pseudoranges and phase using this flag instead of -rinex.\n");
        help.append("                    Be warned that since there is now more data coming from\n");
        help.append("                    the serial port you might start missing some observations.\n");
        help.append("-------------------- ASYNC OPTIONS   ---------------------------------------\n\n");
        help.append("    async -p port_name : Selects serial comm port (comx, ttySx)\n\n");
        help.append("                         Default is com1 (Win) or ttyS0 (Linux)\n\n");
        help.append("    async -t ttt : Sets log time to ttt seconds. Default 30 sec.\n");
        help.append("    async -o filename : Save received packets in filename\n");
        help.append("                        By default the output goes to week_second.g12\n\n");
        help.append("  ---------------------------------------------------------------------------\n\n");
        help.append("    The usual procedure would be to find an unused comm port using\n\n");
        help.append("      async -p com1 -c  or async -p com2 -c (ttyS0,ttyS1 in Linux)\n\n");
        help.append("    Once you find the port, connect your GPS and check if the program sees it\n\n");
        help.append("       async -p comN -i\n\n");
        help.append("    If your GPS is identified you can start logging data using the\n");
        help.append("      async -a -r -rinex or +doppler commands.\n");
        help.append("  ----------------------------------------------------------------------------\n");
        System.out.print(help);
    }

    boolean parse_args(String[] argv, intPtr command, doublePtr log_time, intPtr flag, StringPtr fich) {
        int k = 0;
        GregorianCalendar gmt = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        if (argv.length == 0) {
            this.print_help();
            return false;
        }
        this.PORT = DEF_PORT;
        command.value = 2;
        log_time.value = 30.0;
        flag.value = 65535;
        this.verbose = 1;
        Date tt = new Date();
        gmt.setTime(tt);
        long gps_time = gmt.get(13) + 60 * (gmt.get(12) + 60 * (gmt.get(11) + 24 * (gmt.get(7) - 1)));
        fich.value = gps_time + ".g12";
        while (k < argv.length) {
            if (argv[k].compareTo("-p") == 0) {
                this.PORT = argv[k + 1];
                k += 2;
                continue;
            }
            if (argv[k].compareTo("-h") == 0) {
                this.print_help();
                throw new IllegalArgumentException();
            }
            if (argv[k].compareTo("-i") == 0) {
                command.value = 2;
                ++k;
                continue;
            }
            if (argv[k].compareTo("-rinex") == 0) {
                command.value = 5;
                ++k;
                continue;
            }
            if (argv[k].compareTo("+doppler") == 0) {
                command.value = 6;
                ++k;
                continue;
            }
            if (argv[k].compareTo("-c") == 0) {
                command.value = 1;
                ++k;
                continue;
            }
            if (argv[k].compareTo("-a") == 0) {
                command.value = 3;
                flag.value = Integer.parseInt(argv[k + 1].substring(2), 16);
                k += 2;
                continue;
            }
            if (argv[k].compareTo("-r") == 0) {
                command.value = 4;
                flag.value = Integer.parseInt(argv[k + 1].substring(2), 16);
                k += 2;
                continue;
            }
            if (argv[k].compareTo("-q") == 0) {
                this.verbose = 0;
                ++k;
                continue;
            }
            if (argv[k].compareTo("-V") == 0) {
                this.verbose = 2;
                ++k;
                continue;
            }
            if (argv[k].compareTo("-t") == 0) {
                log_time.value = Integer.parseInt(argv[k + 1]);
                k += 2;
                continue;
            }
            if (argv[k].compareTo("-o") == 0) {
                fich.value = argv[k + 1];
                k += 2;
                continue;
            }
            System.out.println("Unknown Option " + argv[k]);
            ++k;
        }
        System.out.print("-----------------------------------------------------------------\n");
        System.out.print("* Async Software to log raw GPS data from some Garmin handhelds *\n");
        System.out.print("* Version 1.20.   Copyright 2000,2001   Antonio Tabernero Galan *\n");
        System.out.print("* Java port ver. 0.4    (c) 2002,2004  MichalHobot@netscape.net *\n");
        System.out.print("-----------------------------------------------------------------\n");
        if (this.verbose == 2) {
            System.out.println("GPS Time " + gps_time + ". GMT " + " " + (gmt.get(2) + 1) + " " + gmt.get(5) + " " + gmt.get(11) + ":" + gmt.get(12) + ":" + gmt.get(13) + " " + gmt.get(1));
        }
        if (this.verbose != 0) {
            System.out.print("Serial port: " + this.PORT + ". Command: ");
            switch (command.value) {
                case 2: {
                    System.out.print("GPS Identification.\n");
                    break;
                }
                case 1: {
                    System.out.print("Check Comm Port\n");
                    break;
                }
                case 3: {
                    System.out.print("Log async events (mask 0x" + Integer.toHexString(flag.value) + ")\nLog-time " + log_time.value + " sec. ");
                    System.out.print("Output binary file " + fich.value + "\n");
                    break;
                }
                case 4: {
                    System.out.print("Request records (type 0x" + Integer.toHexString(flag.value) + ").\n");
                    System.out.print("Output binary file " + fich.value + "\n");
                    break;
                }
                case 5: {
                    System.out.print("Log async events for Rinex.\nLog-time " + log_time.value + " sec. ");
                    System.out.print("Output binary file " + fich.value + "\n");
                    break;
                }
                case 6: {
                    System.out.print("Log for Rinex (+Doppler).\nLog-time " + log_time.value + " sec. ");
                    System.out.print("Output binary file " + fich.value + "\n");
                    break;
                }
            }
            System.out.print("-----------------------------------------------------------------\n");
        }
        return true;
    }

    public int run(String[] args) {
        intPtr command = new intPtr();
        doublePtr log_time = new doublePtr();
        intPtr flag = new intPtr();
        StringPtr fich = new StringPtr();
        if (!this.parse_args(args, command, log_time, flag, fich)) {
            return -2;
        }
        this.p_error_code = new longPtr();
        this.p_error_code.value = 0L;
        if (command.value != 1) {
            if (!this.clear_line()) {
                this.show_err_msg(this.p_error_code.value);
                return 0;
            }
            this.get_pos(true);
            this.get_date(true);
        }
        switch (command.value) {
            case 2: {
                this.ident();
                break;
            }
            case 1: {
                this.check_port();
                break;
            }
            case 3: {
                if (flag.value != 0) {
                    try {
                        FileOutputStream fd = new FileOutputStream(fich.value);
                        this.ident();
                        this.write_packet(fd);
                        this.get_pos(false);
                        this.write_packet(fd);
                        this.get_date(false);
                        this.write_packet(fd);
                        this.log_packets_async(flag.value, log_time.value, fd);
                        fd.close();
                    }
                    catch (FileNotFoundException e) {
                        this.set_error(20);
                    }
                    catch (IOException e) {
                        this.set_error(21);
                    }
                    break;
                }
                this.async(flag.value);
                break;
            }
            case 4: {
                try {
                    FileOutputStream fd = new FileOutputStream(fich.value);
                    this.log_packets_request(flag.value, fd);
                    fd.close();
                }
                catch (FileNotFoundException e) {
                    this.set_error(20);
                }
                catch (IOException e) {
                    this.set_error(21);
                }
                break;
            }
            case 5: {
                try {
                    FileOutputStream fd = new FileOutputStream(fich.value);
                    this.ident();
                    this.write_packet(fd);
                    this.get_pos(false);
                    this.write_packet(fd);
                    this.get_date(false);
                    this.write_packet(fd);
                    this.log_packets_0x33(fd);
                    this.log_packets_async(32, log_time.value, fd);
                    fd.close();
                }
                catch (FileNotFoundException e) {
                    this.set_error(20);
                }
                catch (IOException e) {
                    this.set_error(21);
                }
                break;
            }
            case 6: {
                try {
                    FileOutputStream fd = new FileOutputStream(fich.value);
                    this.ident();
                    this.write_packet(fd);
                    this.get_pos(false);
                    this.write_packet(fd);
                    this.get_date(false);
                    this.write_packet(fd);
                    this.log_packets_0x33(fd);
                    this.log_packets_async(40, log_time.value, fd);
                    fd.close();
                }
                catch (FileNotFoundException e) {
                    this.set_error(20);
                }
                catch (IOException e) {
                    this.set_error(21);
                }
                break;
            }
            default: {
                this.set_error(31);
                System.out.println("Unknown command");
            }
        }
        this.show_err_msg(this.p_error_code.value);
        return 1;
    }

    class StringPtr {
        public String value;

        StringPtr() {
        }
    }

    class doublePtr {
        public double value;

        doublePtr() {
        }
    }

    class longPtr {
        public long value;

        longPtr() {
        }
    }

    class intPtr {
        public int value;

        intPtr() {
        }
    }

    class bytePtr {
        public byte value;

        bytePtr() {
        }
    }

    class UTC {
        byte month;
        byte day;
        short year;
        short hour;
        byte min;
        byte sec;

        UTC() {
        }
    }

    class D_POS {
        double lat;
        double lon;

        D_POS() {
        }
    }
}

